/*
 *  arch/arm/mach-uniphier/include/mach/io.h
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#include <asm/bug.h>
#include <mach/hardware.h>
#include <linux/kernel.h>

#define IO_SPACE_LIMIT	0xffffffff

static inline void * __iomem __uniphier_io(unsigned long paddr) {
	void __iomem * vaddr;

	switch (paddr) {
	case UNIPHIER_PRIVATE_IO_START ...
	     (UNIPHIER_PRIVATE_IO_START + UNIPHIER_PRIVATE_IO_SIZE - 1):
		vaddr = (void __iomem *)(paddr - UNIPHIER_PRIVATE_IO_START
			 + UNIPHIER_PRIVATE_IO_BASE);
		break;
	case UNIPHIER_AIDET_START ...
	     (UNIPHIER_AIDET_START + UNIPHIER_AIDET_SIZE - 1):
		vaddr = (void __iomem *)(paddr - UNIPHIER_AIDET_START
			 + UNIPHIER_AIDET_BASE);
		break;
	case UNIPHIER_SSC_START0 ...
	     (UNIPHIER_SSC_START0 + UNIPHIER_SSC_SIZE0 - 1):
		vaddr = (void __iomem *)(paddr - UNIPHIER_SSC_START0
			 + UNIPHIER_SSC_BASE0);
		break;
	case UNIPHIER_SSC_START1 ...
	     (UNIPHIER_SSC_START1 + UNIPHIER_SSC_SIZE1 - 1):
		vaddr = (void __iomem *)(paddr - UNIPHIER_SSC_START1
			 + UNIPHIER_SSC_BASE1);
		break;
	case UNIPHIER_SSC_START2 ...
	     (UNIPHIER_SSC_START2 + UNIPHIER_SSC_SIZE2 - 1):
		vaddr = (void __iomem *)(paddr - UNIPHIER_SSC_START2
			 + UNIPHIER_SSC_BASE2);
		break;
	case UNIPHIER_TIMER_START ...
	     (UNIPHIER_TIMER_START + UNIPHIER_TIMER_SIZE - 1):
		vaddr = (void __iomem *)(paddr - UNIPHIER_TIMER_START
			 + UNIPHIER_TIMER_BASE);
		break;
	default:
		printk(KERN_ERR "__uniphier_io: Unmapped address(%08lx)\n", paddr);
		BUG();
	}
	return vaddr;
}

#define __io(a)		__uniphier_io(a)
#define __mem_pci(a)	(a)

#define __arch_ioremap(p,s,t)	__arm_ioremap(p,s,t)
#define __arch_iounmap(v)	__iounmap(v)

extern void write_buffer_drain(void);

#endif
